using System;
using System.Runtime.InteropServices;
using System.Globalization;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Runtime.Serialization.Formatters.Soap;
using System.Xml.Serialization; 
using System.Text;


namespace CSharpRecipes
{
	public class ClassAndStructs
    {
        #region "3.1 Tworzenie struktur dziaajcych jak unie"
        public static void TestUnions()
		{
			Console.WriteLine("\r\n\r\n");
			SignedNumber sNum = new SignedNumber();
			sNum.Num1 = sbyte.MaxValue;
			Console.WriteLine("Num1 = " + sNum.Num1);
			Console.WriteLine("Num2 = " + sNum.Num2);
			Console.WriteLine("Num3 = " + sNum.Num3);
			Console.WriteLine("Num4 = " + sNum.Num4);
			
			sNum.Num4 = long.MaxValue;
			Console.WriteLine("\r\nNum1 = " + sNum.Num1);
			Console.WriteLine("Num2 = " + sNum.Num2);
			Console.WriteLine("Num3 = " + sNum.Num3);
			Console.WriteLine("Num4 = " + sNum.Num4);
			Console.WriteLine("Num5 = " + sNum.Num5);
			Console.WriteLine("Num6 = " + sNum.Num6);
			Console.WriteLine("Num7 = " + sNum.Num7);
			
			
			Console.WriteLine("\r\n\r\n");
			SignedNumberWithText sNumWithText = new SignedNumberWithText();
			sNumWithText.Text1 = "c";
			//sNumWithText.Text2 = "asdfasdf";
			
			sNumWithText.Num1 = sbyte.MaxValue;
			Console.WriteLine("Num1 = " + sNumWithText.Num1);
			Console.WriteLine("Num2 = " + sNumWithText.Num2);
			Console.WriteLine("Num3 = " + sNumWithText.Num3);
			Console.WriteLine("Num4 = " + sNumWithText.Num4);
			Console.WriteLine("Text1 = " + sNumWithText.Text1);
			//Console.WriteLine("Text2 = " + sNumWithText.Text2);
			
			sNumWithText.Num4 = long.MaxValue;
			Console.WriteLine("\r\nNum1 = " + sNumWithText.Num1);
			Console.WriteLine("Num2 = " + sNumWithText.Num2);
			Console.WriteLine("Num3 = " + sNumWithText.Num3);
			Console.WriteLine("Num4 = " + sNumWithText.Num4);
			Console.WriteLine("Num5 = " + sNumWithText.Num5);
			Console.WriteLine("Num6 = " + sNumWithText.Num6);
			Console.WriteLine("Num7 = " + sNumWithText.Num7);			
			Console.WriteLine("Text1 = " + sNumWithText.Text1);
			//Console.WriteLine("Text2 = " + sNumWithText.Text2);
		}


		[StructLayoutAttribute(LayoutKind.Explicit)]
		struct SignedNumber 
		{
			[FieldOffsetAttribute(0)] 
			public sbyte Num1;
    
			[FieldOffsetAttribute(0)] 
			public short Num2;

			[FieldOffsetAttribute(0)] 
			public int Num3;

			[FieldOffsetAttribute(0)] 
			public long Num4;

			[FieldOffsetAttribute(0)] 
			public float Num5;

			[FieldOffsetAttribute(0)] 
			public double Num6;

			[FieldOffsetAttribute(0)] 
			public decimal Num7;
		}

		[StructLayoutAttribute(LayoutKind.Explicit)]
		struct SignedNumberWithText 
		{
			[FieldOffsetAttribute(0)] 
			public sbyte Num1;
    
			[FieldOffsetAttribute(0)] 
			public short Num2;

			[FieldOffsetAttribute(0)] 
			public int Num3;

			[FieldOffsetAttribute(0)] 
			public long Num4;

			[FieldOffsetAttribute(0)] 
			public float Num5;

			[FieldOffsetAttribute(0)] 
			public double Num6;

			[FieldOffsetAttribute(0)] 
			public decimal Num7;

			[FieldOffsetAttribute(16)] 
			public string Text1;
		}
		#endregion

        #region "3.2 Wyprowadzanie wartoci typu w postaci cigu znakw"
        public static void TestLineToString()
        {
            Line V1 = new Line(0, 0, 40, 123);
            Line V2 = new Line(0, -2, 1, 11);
            Line V3 = new Line(0, 1, 0, 1);

            Console.WriteLine("\r\nTest domylnej metody ToString");
            Console.WriteLine("V1 = " + V1);
            Console.WriteLine("V2 = " + V2);
            Console.WriteLine("V1.ToString( ) = {0:V}", V1.ToString());
            Console.WriteLine("V2.ToString( ) = {0:V}", V2.ToString());

            Console.WriteLine("\r\nTest przecionej metody ToString(format)");
            Console.WriteLine("V1.ToString(\"D\") = {0:D}", V1);
            Console.WriteLine("V1.ToString(\"D5\") = {0:D5}", V1);
            Console.WriteLine("V2.ToString(\"F\") = {0:F}", V2);
            Console.WriteLine("V1.ToString(\"N\") = {0:N}", V1);
            Console.WriteLine("V2.ToString(\"n\") = {0:n}", V2);
            Console.WriteLine("V1.ToString(\"E\") = {0:E}", V1);
            Console.WriteLine("V2.ToString(\"X\") = {0:X}", V2);

            Console.WriteLine("\r\nTest przecionej metody ToString(formatProvider)");
            NumberFormatInfo NullFormatter = null;
            NumberFormatInfo Formatter = new NumberFormatInfo();
            Formatter.NegativeSign = "!";
            Formatter.PositiveSign = "+";
            Console.WriteLine("V2.ToString(Formatter) = " + V2.ToString(Formatter));
            Console.WriteLine("V2.ToString(Formatter) = " + V2.ToString(Formatter));
            Console.WriteLine("V2.ToString(null) = " + V2.ToString(NullFormatter));
            Console.WriteLine("V2.ToString(null) = " + V2.ToString(NullFormatter));
            Console.WriteLine("V2.ToString(new CultureInfo(\"fr-BE\")) = "
                    + V2.ToString(new CultureInfo("fr-BE")));  //francuski - Belgia
            Console.WriteLine("V2.ToString(new CultureInfo(\"fr-BE\")) = "
                    + V2.ToString(new CultureInfo("fr-BE")));  //francuski - Belgia

            Console.WriteLine
                    ("\r\nTest przecionej metody ToString(format, formatProvider)");
            Console.WriteLine("V2.ToString(\"D\", Formatter) = " + V2.ToString("D",
                               Formatter));
            Console.WriteLine("V2.ToString(\"F\", Formatter) = " + V2.ToString("F",
                               Formatter));
            Console.WriteLine("V2.ToString(\"D\", null) = " + V2.ToString("D", null));
            Console.WriteLine("V2.ToString(\"F\", null) = " + V2.ToString("F", null));
            Console.WriteLine("V2.ToString(\"D\", new CultureInfo(\"fr-BE\")) = "
                    + V2.ToString("D", new CultureInfo("fr-BE")));  //francuski - Belgia
            Console.WriteLine("V2.ToString(\"F\", new CultureInfo(\"fr-BE\")) = "
                    + V2.ToString("F", new CultureInfo("fr-BE")));  //francuski - Belgia
            Console.WriteLine("\r\nTest przecionej metody ToString(\"V\", formatProvider)");
            Console.WriteLine("V2.ToString(\"V\", Formatter) = " + V2.ToString("V",
                               Formatter));
            Console.WriteLine("V2.ToString(\"V\", null) = " + V2.ToString("V", null));
        }



        public struct Line : IFormattable
        {
            public Line(int startX, int startY, int endX, int endY)
            {
                x1 = startX;
                x2 = endX;
                y1 = startY;
                y2 = endY;
            }

            public int x1;
            public int y1;
            public int x2;
            public int y2;

            public override bool Equals(object obj)
            {
                bool isEqual = false;
                if (obj == null || (this.GetType() != obj.GetType()))
                {
                    isEqual = false;
                }
                else
                {
                    Line theLine = (Line)obj;
                    isEqual = (this.x1 == theLine.x1) &&
                     (this.y1 == theLine.y1) &&
                     (this.x2 == theLine.x2) &&
                     (this.y2 == theLine.y2);
                }
                return (isEqual);
            }

            public bool Equals(Line lineObj)
            
            {
                bool isEqual = (this.x1 == lineObj.x1) &&
                (this.y1 == lineObj.y1) &&
                (this.x2 == lineObj.x2) &&
                (this.y2 == lineObj.y2);

                return (isEqual);
            }

            public override int GetHashCode()
            {
                return ((x1 + x2) ^ (y1 + y2));
            }
            public static Line Parse(string stringLine)
            {
                if (stringLine == null)
                {
                    throw (new ArgumentNullException(
                           "stringLine",
                           "Nie mona przekaza wartoci null do metody Parse."));
                }

                // Pobranie cigu (x1,y1)(x2,y2) i przeksztacenie na obiekt Line.
                int X1 = 0;
                int Y1 = 0;
                int X2 = 0;
                int Y2 = 0;

                MatchCollection MC = Regex.Matches(stringLine,
                    @"\s*\(\s*(?<x1>\d+)\s*\,\s*(?<y1>\d+)\s*\)\s*\(\s*(?<x2>" +
                    @"\d+)\s*\,\s*(?<y2>\d+)\s*\)");

                if (MC.Count == 1)
                {
                    Match M = MC[0];
                    X1 = int.Parse(M.Groups["x1"].Value);
                    Y1 = int.Parse(M.Groups["y1"].Value);
                    X2 = int.Parse(M.Groups["x2"].Value);
                    Y2 = int.Parse(M.Groups["y2"].Value);
                }
                else
                {
                    throw (new ArgumentException("Podana warto " + stringLine +
                                                 "nie ma waciwego formatu dla wartoci Line."));
                }
                return (new Line(X1, Y1, X2, Y2));
            }

            public double GetDirectionInRadians()
            {
                int xSide = x2 - x1;
                int ySide = y2 - y1;
                if (xSide == 0)    // Zabezpieczenie przed dzieleniem przez zero.
                    return (0);
                else
                    return (Math.Atan(ySide / xSide));
            }

            public double GetMagnitude()
            {
                int xSide = x2 - x1;
                int ySide = y2 - y1;
                return (Math.Sqrt(Math.Sqrt((xSide * xSide) + (ySide * ySide))));
            }

            public override string ToString()
            {
                return (String.Format("({0},{1}) ({2},{3})", x1, y1, x2, y2));
            }

            public string ToString(string format)
            {
                return (this.ToString(format, null));
            }

            public string ToString(IFormatProvider formatProvider)
{
    return (this.ToString(null, formatProvider));
}

            public string ToString(string format, IFormatProvider formatProvider)
{
    StringBuilder compositeStr = new StringBuilder("");

    if ((format != null) && (format.ToUpper().Equals("V")))
    {
            double direction = this.GetDirectionInRadians();
            double magnitude = this.GetMagnitude();

            string retStringD = direction.ToString("G5", formatProvider);
            string retStringM = magnitude. ToString("G5", formatProvider);

            compositeStr.Append(
                 "dugo = ").Append(retStringM).Append(
                             "\tKierunek = ").Append(retStringD);
        }
        else
        {
            string retStringX1 = this.x1.ToString(format, formatProvider);
            string retStringY1 = this.y1.ToString(format, formatProvider);
            string retStringX2 = this.x2.ToString(format, formatProvider);
            string retStringY2 = this.y2.ToString(format, formatProvider);

            compositeStr.Append("(").Append(retStringX1).Append(",").Append(
                  retStringY1).Append(")(").
                        Append(retStringX2).Append(",").Append(
                               retStringY2).Append(")");
        }
        return (compositeStr.ToString());
    }
        }

		#endregion

        #region "3.3 Konwersja znakowej reprezentacji obiektu na obiekt"
        public static void TestParse()
		{
			Console.WriteLine("Line.Parse(\"(12,2)(0,45)\") = " + Line.Parse("(12,2)(0,45)"));
			Console.WriteLine("Line.Parse(\"(0,0)(0,0)\") = " + Line.Parse("(0,0)(0,0)"));
			//Console.WriteLine("Line.Parse(\"()(0,45)\") = " + Line.Parse("()(0,45)"));
			//Console.WriteLine("Line.Parse(\"foo\") = " + Line.Parse("foo"));
			//Console.WriteLine("Line.Parse(\"\") = " + Line.Parse(""));
			//Console.WriteLine("Line.Parse(null) = " + Line.Parse(null));
			
			Line l1 = new Line(0,0,0,0);
			Line l2 = new Line(0,0,0,0);
			//l1 += l2;
		}
        #endregion

        #region "3.4 Implementacja polimorfizmu za pomoc abstrakcyjnych klas bazowych"
        public static void TestMediaABC()
        {
            Media x = new Magnetic();
            UseMedia(x);

            Console.WriteLine();
            x = new Optical();
            UseMedia(x);

            Console.WriteLine();

            x = new PunchCard();
            UseMedia(x);
        }

        private static void UseMedia(Media media)
        {
            media.Init();
            media.WriteTo("text");
            media.ReadFrom();

            Console.WriteLine(media.Handle);
            media.Close();

            Console.WriteLine(media.ToString());
        }

		public abstract class Media
		{
			public abstract void Init();
			public abstract void WriteTo(string data);
			public abstract string ReadFrom();
			public abstract void Close();

			private IntPtr mediaHandle = IntPtr.Zero;

			public IntPtr Handle
			{
				get {return(mediaHandle);}
			}
		}

		public class Magnetic : Media
{
    public override void Init()
    {
        Console.WriteLine("Magnetic Init");
    }

    public override void WriteTo(string data)
    {
        Console.WriteLine("Magnetic Write");
    }

    public override string ReadFrom()
    {
        Console.WriteLine("Magnetic Read");

        string data = "";
        return (data);
    }

    public override void Close()
    {
        Console.WriteLine("Magnetic Close");
    }
}

public class Optical : Media
{
    public override void Init()
    {
        Console.WriteLine("Optical Init");
    }

    public override void WriteTo(string data)
    {
        Console.WriteLine("Optical Write");
    }
    public override string ReadFrom()
    {
        Console.WriteLine("Optical Read");
        string data = "";
        return (data);
    }
    public override void Close()
    {
        Console.WriteLine("Optical Close");
    }
}

public class PunchCard : Media
{
    public override void Init()
    {
        Console.WriteLine("PunchCard Init");
    }

    public override void WriteTo(string data)
    {
        Console.WriteLine("PunchCard WriteTo");
    }

    public override string ReadFrom()
    {
        Console.WriteLine("PunchCard ReadFrom");

        string data = "";
        return (data);
    }

    public override void Close()
    {
        Console.WriteLine("PunchCard Close");
    }
}

		#endregion

#region "3.5 Zapewnienie moliwoci sortowania danych zdefiniowanego typu"
public static void TestSort()
{
    Square[] arrayOfSquares = new Square[4] {new Square(1,3),
                                             new Square(4,3),
                                             new Square(2,1),
                                             new Square(6,1)};
    ArrayList arrayListOfSquares = new ArrayList();
    arrayListOfSquares.Add(new Square(1,3));
    arrayListOfSquares.Add(new Square(4,3));
    arrayListOfSquares.Add(new Square(1,1));
    arrayListOfSquares.Add(new Square(6,1));

    IComparer HeightCompare = new CompareHeight();

    // Testowanie klasy Array.
    Console.WriteLine("ARRAY");
    Console.WriteLine("Pocztkowa zawarto tablicy");
        foreach (Square s in arrayOfSquares)
        {
            Console.WriteLine(s.ToString());
        }
        Console.WriteLine();
        Console.WriteLine("Posortowana tablica z wykorzystaniem argumentu IComparer=HeightCompare");
        Array.Sort(arrayOfSquares, HeightCompare);
        foreach (Square s in arrayOfSquares)
        {
            Console.WriteLine(s.ToString());
        }

        Console.WriteLine();
        Console.WriteLine("Posortowana tablica z wykorzystaniem interfejsu IComparable");
        Array.Sort(arrayOfSquares);
        foreach (Square s in arrayOfSquares)
        {
            Console.WriteLine(s.ToString());
        }

        // Testowanie typu ARRAYLIST.
        Console.WriteLine();
        Console.WriteLine();
        Console.WriteLine("ARRAYLIST");
        foreach (Square s in arrayListOfSquares)
        {
            Console.WriteLine(s.ToString());
        }

        Console.WriteLine();
        Console.WriteLine("Posortowany obiekt ArrayList z wykorzystaniem argumentu IComparer=HeightCompare");
        arrayListOfSquares.Sort(HeightCompare);
        foreach (Square s in arrayListOfSquares)
        {
            Console.WriteLine(s.ToString());
        }

        Console.WriteLine();
        Console.WriteLine("Posortowany obiekt ArrayList z wykorzystaniem interfejsu IComparable");
        arrayListOfSquares.Sort();
        foreach (Square s in arrayListOfSquares)
        {
             Console.WriteLine(s.ToString());
        }

        // Test dla danych klasy SORTEDLIST.
        SortedList SortedListOfSquares = new SortedList();
        SortedListOfSquares.Add(0, new Square(1,3));
        SortedListOfSquares.Add(2, new Square(4,3));
        SortedListOfSquares.Add(1, new Square(2,1));
        SortedListOfSquares.Add(3, new Square(6,1));

        Console.WriteLine();
        Console.WriteLine();
        Console.WriteLine("SORTEDLIST");
        foreach (DictionaryEntry s in SortedListOfSquares)
        {

				Console.WriteLine(s.Key + " : " + ((Square)s.Value).ToString());
			}
		}


        public class Square : IComparable
        {
            public Square() { }
            public Square(int height, int width)
            {
                this.height = height;
                this.width = width;
            }

            private int height;
            private int width;

            public int Height
            {
                get { return (height); }
                set { height = value; }
            }

            public int Width
            {
                get { return (width); }
                set { width = value; }
            }

            public int CompareTo(object obj)
            {
                if (this.GetType() != obj.GetType())
                {
                    throw (new ArgumentException(
                            "Obydwa porwnywane obiekty musz by typu Square."));
                }
                else
                {
                    Square square2 = (Square)obj;

                    long area1 = this.Height * this.Width;
                    long area2 = square2.Height * square2.Width;


                    if (area1 == area2)
                    {
                        return (0);
                    }
                    else if (area1 > area2)
                    {
                        return (1);
                    }
                    else
                    {
                        return (-1);
                    }
                }
            }
            public override string ToString()
            {
                return ("Wysoko:" + height + " Szeroko:" + width);
            }
        }

		public class CompareHeight : IComparer
		{
			public int Compare(object obj1, object obj2)
			{
				if (!(obj1 is Square) || !(obj2 is Square))
				{
					throw (new ArgumentException("Both parameters must be of type Square."));
				}
				else
				{
					Square square1 = (Square)obj1;
					Square square2 = (Square)obj2;

					if (square1.Height == square2.Height)
					{
						return (0);
					}
					else if (square1.Height > square2.Height)
					{
						return (1);
					}
					else if (square1.Height < square2.Height)
					{
						return (-1);
					}
					else
					{
						return (-1);
					}
				}
			}
		}
		#endregion

        #region "3.6 Zapewnienie moliwoci wyszukiwania danych typu"
        // Typ Square zdefiniowano w poprzednim obszarze.

        public static void TestSearch()
        {
            Square[] arrayOfSquares = new Square[4] {new Square(1,3),
                                             new Square(4,3),
                                             new Square(2,1),
                                             new Square(6,1)};

            ArrayList arrayListOfSquares = new ArrayList();
            arrayListOfSquares.Add(new Square(1, 3));
            arrayListOfSquares.Add(new Square(4, 3));
            arrayListOfSquares.Add(new Square(2, 1));
            arrayListOfSquares.Add(new Square(6, 1));

            IComparer HeightCompare = new CompareHeight();

            // Testowanie klasy ARRAY.
            Console.WriteLine("ARRAY");
            Console.WriteLine("Pocztkowa zawarto tablicy");
            foreach (Square s in arrayOfSquares)
            {
                Console.WriteLine(s.ToString());
            }

            Console.WriteLine();
            Console.WriteLine("Posortowana tablica z wykorzystaniem argumentu IComparer=HeightCompare");
            Array.Sort(arrayOfSquares, HeightCompare);
            foreach (Square s in arrayOfSquares)
            {
                Console.WriteLine(s.ToString());
            }

            Console.WriteLine();
            Console.WriteLine("Wyszukiwanie z wykorzystaniem argumentu IComparer=HeightCompare");
            int found = Array.BinarySearch(arrayOfSquares, new Square(1, 3), HeightCompare);
            Console.WriteLine("znaleziono (1,3): " + found);

            Console.WriteLine();
            Console.WriteLine("Posortowana tablica z wykorzystaniem interfejsu IComparable");
            Array.Sort(arrayOfSquares);
            foreach (Square s in arrayOfSquares)
            {
                Console.WriteLine(s.ToString());
            }

            Console.WriteLine("Wyszukiwanie z wykorzystaniem interfejsu IComparable");
            found = Array.BinarySearch(arrayOfSquares,
                                       new Square(6, 1), null);  // Wykorzystanie interfejsu IComparable.
            Console.WriteLine("znaleziono (6,1): " + found);

            // Testowanie typu ARRAYLIST.
            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("ARRAYLIST");
            foreach (Square s in arrayListOfSquares)
            {
                Console.WriteLine(s.ToString());
            }

            Console.WriteLine();
            Console.WriteLine("Posortowana lista ArrayList z wykorzystaniem argumentu IComparer=HeightCompare");
            arrayListOfSquares.Sort(HeightCompare);
            foreach (Square s in arrayListOfSquares)
            {
                Console.WriteLine(s.ToString());
            }

            Console.WriteLine();
            Console.WriteLine("Wyszukiwanie z wykorzystaniem argumentu IComparer=HeightCompare");
            found = arrayListOfSquares.BinarySearch(new Square(1, 3), HeightCompare);
            Console.WriteLine("znaleziono (1,3): " + found);
            Console.WriteLine();
            Console.WriteLine("Posortowany obiekt ArrayList z wykorzystaniem interfejsu IComparable");
            arrayListOfSquares.Sort();
            foreach (Square s in arrayListOfSquares)
            {
                Console.WriteLine(s.ToString());
            }

            Console.WriteLine();
            Console.WriteLine("Wyszukiwanie z wykorzystaniem interfejsu IComparable");
            found = arrayListOfSquares.BinarySearch(new Square(6, 1), null);
            Console.WriteLine("znaleziono (6,1): " + found);
            // Test dla danych klasy SORTEDLIST.
            SortedList SortedListOfSquares = new SortedList();
            SortedListOfSquares.Add(0, new Square(1, 3));
            SortedListOfSquares.Add(2, new Square(4, 3));
            SortedListOfSquares.Add(1, new Square(2, 1));
            SortedListOfSquares.Add(3, new Square(6, 1));
            Console.WriteLine();

            Console.WriteLine();
            Console.WriteLine("SORTEDLIST");
            foreach (DictionaryEntry s in SortedListOfSquares)
            {
                Console.WriteLine(s.Key + " : " + ((Square)s.Value).ToString());
            }

            Console.WriteLine();
            bool foundBool = SortedListOfSquares.Contains(2);
            Console.WriteLine("SortedListOfSquares.Contains(2): " + foundBool);

            foundBool = SortedListOfSquares.ContainsKey(2);
            Console.WriteLine("SortedListOfSquares.ContainsKey(2): " + foundBool);

            // Nie wykorzystuje interfejsw IComparer lub IComparable
            // -- korzysta z wyszukiwania liniowego wraz z metod Equals, ktrej nie przeciono.
            // Gdyby obiekt Square wykorzystano jako klucz a nie
            // warto, aby znale ten obiekt Square, naleaoby skorzysta
            // z wyszukiwania binarnego.
            Square value = new Square(6, 1);
            foundBool = SortedListOfSquares.ContainsValue(value);
            Console.WriteLine("SortedListOfSquares.ContainsValue(new Square(6,1)): " + foundBool);
        }

        #endregion

        #region "3.7 Porednie przecianie operatorw +=, -=, /= i *="
        public class Foo
        {
            // Inne skadowe klasy...
            // Przecione operatory binarne
            public static Foo operator +(Foo f1, Foo f2)
            {
                Foo result = new Foo();

                // Dodawanie wartoci f1 i f2...
                // umieszczenie wyniku dodawania w zmiennej  result.

                return (result);
            }

            public static Foo operator +(int constant, Foo f1)
            {
                Foo result = new Foo();
                // Dodawanie wartoci staej cakowitej do zmiennej f1 ...
                // umieszczenie wyniku dodawania w zmiennej result.

                return (result);
            }
            public static Foo operator +(Foo f1, int constant)
            {
                Foo result = new Foo();
                // Dodawanie wartoci staej cakowitej do zmiennej f1 ...
                // umieszczenie wyniku dodawania w zmiennej result.
                return (result);
            }
            public static Foo operator -(Foo f1, Foo f2)
            {
                Foo result = new Foo();

                // Odejmowanie wartoci f2 od f1...
                // umieszczenie wyniku odejmowania w zmiennej result.

                return (result);
            }

            public static Foo operator -(int constant, Foo f1)
            {
                Foo result = new Foo();

                // Odejmowanie wartoci zmiennej f1 od staej cakowitej ...
                // umieszczenie wyniku odejmowania w zmiennej result.

                return (result);
            }

            public static Foo operator -(Foo f1, int constant)
            {
                Foo result = new Foo();

                //Odejmowanie wartoci staej cakowitej od zmiennej f1...
                // umieszczenie wyniku odejmowania w zmiennej result.

                return (result);
            }
            public static Foo operator *(Foo f1, Foo f2)
            {
                Foo result = new Foo();

                // Mnoenie wartoci f1 i f2...
                // umieszczenie wyniku mnoenia w zmiennej result.

                return (result);
            }

            public static Foo operator *(int multiplier, Foo f1)
            {
                Foo result = new Foo();

                // Mnoenie wartoci f1 przez liczb... 
                // umieszczenie wyniku mnoenia w zmiennej result.

                return (result);
            }

            public static Foo operator *(Foo f1, int multiplier)
            {
                return (multiplier * f1);
            }

            public static Foo operator /(Foo f1, Foo f2)
            {
                Foo result = new Foo();

                // Dzielenie wartoci f1 przez f2...
                // umieszczenie wyniku odejmowania w zmiennej result.

                return (result);
            }

            public static Foo operator /(int numerator, Foo f1)
            {
                Foo result = new Foo();

                // Dzielenie licznika przez zmienn fl...
                // umieszczenie wyniku dzielenia w zmiennej result.

                return (result);
            }

            public static Foo operator /(Foo f1, int denominator)
            {
                return (1 / (denominator / f1));
            }
        }

		#endregion

        #region "3.8 Porednie przecianie operatorw &&, || i ?:"
        public static void TestObjState()
		{
			ObjState osOn = new ObjState(1);
			ObjState osOff = new ObjState(-1);
			
			Console.WriteLine((osOn && osOn));		// 1		true
			Console.WriteLine((osOn && osOff));		// 1		false
			Console.WriteLine((osOff && osOn));		// -1		false
			Console.WriteLine((osOn || osOff));		// 1		true
			Console.WriteLine((osOff || osOff));	// -1		false
//			Console.WriteLine((osOn & osOff));		// -1
//			Console.WriteLine((osOn & osOn));		// 1
//			Console.WriteLine((osOn | osOff));		// 1
//			Console.WriteLine((osOff | osOff));		// -1
			Console.WriteLine((osOn ? "A" : "B" ));	// A
			Console.WriteLine((osOff ? "C" : "D"));	// D
			Console.WriteLine((osOn ? "A" : "B" ));	// A
			Console.WriteLine((osOff ? "C" : "D"));	// D
			Console.WriteLine(((osOff || osOn) ? "C" : "D"));	// C
			
			Console.WriteLine((osOn.RetObj(1) && osOff.RetObj(1)));	
			Console.WriteLine((osOn.RetObj(-1) && osOff.RetObj(1)));
			Console.WriteLine((osOn.RetObj(1) && osOff.RetObj(-1)));
			Console.WriteLine((osOn.RetObj(-1) && osOff.RetObj(-1)));		
		}


		public class ObjState
		{
			public ObjState(int state)
			{
				this.state = state;
			}

			public int state = 0;

			public static implicit operator bool(ObjState obj) 
			{
				if (obj.state == 0)
				{
					throw new InvalidOperationException();
				}
				
				return (obj.state > 0);
			}

			public ObjState RetObj(int state)
			{
				return (new ObjState(state));
			}
			
//			public static ObjState operator &(ObjState obj1, ObjState obj2)
//			{
//				if (obj1 == null || obj2 == null)
//				{
//					throw (new ArgumentNullException("Neither object may be null."));
//				}
//
//				if (obj1.state >= 0 && obj2.state >= 0)
//					return (new ObjState(1));
//				else
//					return (new ObjState(-1));
//			}
//
//			public static ObjState operator |(ObjState obj1, ObjState obj2)
//			{
//				if (obj1.state < 0 && obj2.state < 0)
//					return (new ObjState(-1));
//				else
//					return (new ObjState(1));
//			}
//
//			public static bool operator true(ObjState obj)
//			{
//				if (obj.state >= 0)
//					return (true);
//				else
//					return (false);
//			}
//
//			public static bool operator false(ObjState obj) 
//			{
//				if (obj.state >= 0)
//					return (true);
//				else
//					return (false);
//			}

			public override string ToString()
			{
				return (state.ToString());
			}
		}
		#endregion

        #region "3.9 Improving the Performance of a Structures Equals Method"
		public struct Line2
		{
			public Line2(int startX, int startY, int endX, int endY)
			{
				x1 = startX;
				x2 = endX;
				y1 = startY;
				y2 = endY;
			}

			private int x1;
			private int y1;
			private int x2;
			private int y2;

			public override bool Equals(object obj)
			{
				bool isEqual = false;

				if (obj == null || (this.GetType() != obj.GetType())) 
				{
					isEqual = false;
				}
				else
				{
					Line2 theLine = (Line2)obj;
					isEqual = (this.x1 == theLine.x1) && 
						(this.y1 == theLine.y1) && 
						(this.x2 == theLine.x2) && 
						(this.y2 == theLine.y2);
				}
				return (isEqual);
			}

			public override int GetHashCode()
			{
				return (x1+109*(x2+113*(y1+127*y2)));
			}
		}


		public struct GenericData<T> : IComparable<GenericData<T>>
			where T : struct
		{
			public GenericData(T data)
			{
				_data = data;
			}

			private T _data;

			public int CompareTo(GenericData<T> otherData)
			{
				if (this.GetType() != otherData.GetType())
				{
					throw (new ArgumentException("Both objects being compared must be of type GenericData<T>."));
				}
				else
				{
					if (this._data is int)
					{
						if ((int)(object)this._data == (int)(object)otherData._data)
						{
							return (0);
						}
						else if ((int)(object)this._data > (int)(object)otherData._data)
						{
							return (1);
						}
						else if ((int)(object)this._data < (int)(object)otherData._data)
						{
							return (-1);
						}
						else
						{
							return (-1);
						}
					}
					else
					{
						throw (new ArgumentException("Data within objects being compared are not of type int."));
					}
				}
			}

			public bool Equals(GenericData<T> otherData)
			{
				bool isEqual = false;

				if (this.GetType() != otherData.GetType())
				{
					throw (new ArgumentException("Both objects being compared must be of type GenericData<T>."));
				}
				else
				{
					GenericData<T> tempData = (GenericData<T>)(object)otherData;

					isEqual = ((int)(object)this._data == (int)(object)tempData._data);
				}

				return (isEqual);
			}
		}
		#endregion

        #region "3.10 Wczanie i wyczanie bitw"
        public class BitFlipper
		{
			public static int TurnBitOn(int value, int bitToTurnOn)
			{
				return (value | bitToTurnOn);
			}

			public static int TurnBitOff(int value, int bitToTurnOff)
			{
				return (value & ~bitToTurnOff);
			}
	
			public static int FlipBit(int value, int bitToFlip)
			{
				return (value ^ bitToFlip);
			}
		}

        [Flags]
        public enum ColorBitMask
        {
            NoColorBitMask = 0,         //warto dwjkowa == 00000000
            RedBitMask = 1,             //warto dwjkowa == 00000001
            GreenBitMask = 2,           //warto dwjkowa == 00000010
            BlueBitMask = 4,            //warto dwjkowa == 00000100
            BlackBitMask = 8,           //warto dwjkowa == 00001000
            GreyBitMask = 16,           //warto dwjkowa == 00010000
            SilverBitMask = 32,         //warto dwjkowa == 00100000
            OliveBitMask = 64,          //warto dwjkowa == 01000000
            TealBitMask = 128,          //warto dwjkowa == 10000000
            YellowBitMask = 3,          //warto dwjkowa == 00000011
            VioletBitMask = 5,          //warto dwjkowa == 00000101
            WhiteBitMask = 7,           //warto dwjkowa == 00000111
        }
		#endregion

        #region "3.11 Tworzenie bezbdnych wyrae"
        // Opis znajduje si w recepturze 3.10 w tekcie ksiki.
		#endregion

        #region "3.12 Upraszczanie wyrae logicznych"
        //Opis znajduje si w recepturze 3.10 w tekcie ksiki.
		#endregion

        #region "3.13 Konwersja prostych typw danych w sposb niezaleny od jzyka"
        public static void ConvertCode()
		{
			float initialValue = 0;
			int finalValue = 0;

			initialValue = (float)13.499;
			finalValue = (int)initialValue;
			Console.WriteLine(finalValue.ToString());

			initialValue = (float)13.5;
			finalValue = (int)initialValue;
			Console.WriteLine(finalValue.ToString());

			initialValue = (float)13.501;
			finalValue = (int)initialValue;
			Console.WriteLine(finalValue.ToString());
			
			
			finalValue = Convert.ToInt32((float)13.449);
			Console.WriteLine(finalValue.ToString());

			finalValue = Convert.ToInt32((float)13.5);
			Console.WriteLine(finalValue.ToString());

			finalValue = Convert.ToInt32((float)13.501);
			Console.WriteLine(finalValue.ToString());
		}
		#endregion

        #region "3.14 Kiedy naley uywa operatora cast, a kiedy as lub is?"
        // Opis znajduje si w recepturze 3.13 w tekcie ksiki.
		#endregion

        #region "3.15 Konwersja za pomoc operatora as"
        public class Base {}
		public class Specific : Base {}

        public static void ConvertObj(Base baseObj)
        {
            Specific specificObj = baseObj as Specific;
            if (baseObj == null)
            {
                // Konwersja nie powioda si.
            }
            else
            {
                // Konwersja powioda si.
            }
        }
		
	
		public class TestAsOp<T>
			where T: class
		{
			public T ConvertSomething(object obj)
			{
				return (obj as T);
			}
		}
		#endregion

        #region "3.16 Sprawdzanie typu zmiennej za pomoc operatora is"
        public class Point2D {}
		public class Point3D {}
		public class ExPoint2D : Point2D {}
		public class ExPoint3D : Point3D {}
		
		public object CreatePoint(int pointType)
		{
			switch (pointType) 
			{
				case 0:
					return (new Point2D());
				case 1:
					return (new Point3D());
				case 2:
					return (new ExPoint2D());
				case 3:
					return (new ExPoint3D());
				default:
					return (null);
			}
		}
		
		public void CreateAndHandlePoint()
		{
            // Utworzenie nowego obiektu opisujcego punkt i zwrcenie go.
			object retObj = CreatePoint(3);

            // Obsuga obiektu opisujcego punkt na podstawie jego faktycznego typu.
			if (retObj is ExPoint2D)
			{
                Console.WriteLine("Zastosowano typ ExPoint2D");
			}
			else if (retObj is ExPoint3D)
			{
                Console.WriteLine("Zastosowano typ ExPoint3D");
			}
			else if (retObj is Point2D)
			{
                Console.WriteLine("Zastosowano typ Point2D");
			}
			else if (retObj is Point3D)
			{
                Console.WriteLine("Zastosowano typ Point3D");
			}
			else 
			{
                Console.WriteLine("Niewaciwy typ danych.");
			}
		}
		#endregion

        #region "3.17 Implementacja polimorfizmu za pomoc interfejsw"
        public static void TestIPrintInterface()
{
    // Utworzenie obiektu InventoryItems i wypenienie go danymi.
    IPrint obj = new InventoryItems<string>();
    ((InventoryItems<string>)obj).Add("Towar1");
    ((InventoryItems<string>)obj).Add("Towar2");

    // Wywietlenie informacji o obiekcie.
    CommonPrintMethod(obj);

    Console.WriteLine();

    // Utworzenie obiektu Personnel i wypenienie go danymi.
    obj = new Personnel<string>();
    ((Personnel<string>)obj).Add("Osoba1");
    ((Personnel<string>)obj).Add("Osoba2");

    // Wywietlenie informacji o obiekcie.
    CommonPrintMethod(obj);
}
private static void CommonPrintMethod(IPrint obj)
{
    Console.WriteLine(obj.ToString());
    obj.Print();
}


		public interface IPrint
		{
			void Print();
		}

		public class InventoryItems<T> : List<T>, IPrint
		{
			public void Print()
			{
				foreach (T obj in this)
				{
					Console.WriteLine("Towar magazynowy: " + obj);
				}
			}
		}

		public class Personnel<T> : List<T>, IPrint
		{
			public void Print()
			{
				foreach (T obj in this)
				{
					Console.WriteLine("Osoba: " + obj);
				}
			}
		}
		#endregion

        #region "3.18 Wywoywanie tej samej metody dla wielu typw obiektowych"
        public static void SortAllObjects(IMySort[] sortableObjects)
        {
            foreach (IMySort m in sortableObjects)
            {
                m.Sort();
            }
        }
  
		public interface IMySort
		{
			void Sort();
		}

        public class CharContainer : IMySort
        {
            public void Sort()
            {
                // Operacje sortowania cigw znakw.
                Console.WriteLine("Dane tekstowe posortowano");
            }
        }
            public class NumberContainer : IMySort
{
    public void Sort()
    {
        // Operacje sortowania liczb.
        Console.WriteLine("Liczby posortowano");
    }
}
public class ObjectContainer : IMySort
{
    public void Sort()
    {
        // Operacje sortowania danych obiektowych.
        Console.WriteLine("Obiekty posortowano");
    }
}

		#endregion

#region "3.19 Implementacja wywoywanej zwrotnie metody powiadamiajcej z wykorzystaniem interfejsw"

public static void CallBackThroughIFace()
        {
            NotifyClient notificationObj = new NotifyClient();
            Task t = new Task(notificationObj);
            t.ProcessSomething();

            Console.WriteLine();

            t.UnAttachCallback();
            t.ProcessSomething();

            Console.WriteLine();
            t.AttachToCallback(notificationObj);
            t.ProcessSomething();

            Console.WriteLine();

            t.UnAttachCallback();
            t.ProcessSomething();
        }

        public static void MultiCallBackThroughIFace()
        {
            NotifyClient notificationObj = new NotifyClient();
            MultiTask t = new MultiTask(notificationObj);
            t.ProcessSomething();

            Console.WriteLine();

            t.AttachToCallback(notificationObj);
            t.ProcessSomething();

            Console.WriteLine();
            t.UnAttachCallback(notificationObj);

            t.ProcessSomething();
            Console.WriteLine();

            t.UnAttachAllCallbacks();
            t.ProcessSomething();
        }



		public interface INotificationCallbacks
		{
			void FinishedProcessingSubGroup(int amount);
			void FinishedProcessingGroup();
		}

		public class NotifyClient : INotificationCallbacks
		{
			public void FinishedProcessingSubGroup(int amount)
			{
				Console.WriteLine("Zakoczono przetwarzanie " + amount + " pozycji");
			}

			public void FinishedProcessingSubGroup(int amount, int total)
			{
				Console.WriteLine("Zakoczono przetwarzanie " + amount + " z " + total + " pozycji");
			}

			public void FinishedProcessingGroup()
			{
				Console.WriteLine("Przetwarzanie zakoczono");
			}
		}

        public class MultiTask
        {
            public MultiTask(NotifyClient notifyClient)
            {
                notificationObjs.Add(notifyClient);
            }

            ArrayList notificationObjs = new ArrayList();

            public void AttachToCallback(NotifyClient notifyClient)
            {
                notificationObjs.Add(notifyClient);
            }

            public void UnAttachCallback(NotifyClient notifyClient)
            {
                notificationObjs.Remove(notifyClient);
            }

            public void UnAttachAllCallbacks()
            {
                notificationObjs.Clear();
            }
            public void ProcessSomething()
            {
                // W tej metodzie mona wprowadzi dowolne obliczenia.

                for (int counter = 0; counter < 100; counter++)
                {
                    if ((counter % 10) == 0)
                    {
                        foreach (NotifyClient callback in notificationObjs)
                        {
                            callback.FinishedProcessingSubGroup(counter);
                        }
                    }
                }
                foreach (NotifyClient callback in notificationObjs)
                {
                    callback.FinishedProcessingGroup();
                }
            }
        }

        public class Task
		{
			public Task(NotifyClient notifyClient)
			{
				notificationObj = notifyClient;
			}

			NotifyClient notificationObj = null;

			public void AttachToCallback(NotifyClient notifyClient)
			{
				notificationObj = notifyClient;
			}

			public void UnAttachCallback()
			{
				notificationObj = null;
			}


            public void ProcessSomething()
            {
                // W tej metodzie mona wprowadzi dowolne obliczenia.
                for (int counter = 0; counter < 100; counter++)
                {
                    if ((counter % 10) == 0)
                    {
                        if (notificationObj != null)
                        {
                            notificationObj.FinishedProcessingSubGroup(counter);
                        }
                    }
                }
                if (notificationObj != null)
                {
                    notificationObj.FinishedProcessingGroup();
                }
            }
        }

		#endregion

        #region "3.20 Wykorzystanie wielu punktw wejcia w celu stworzenia kilku wersji aplikacji"
        //		public class ClientABC
//		{
//			public static void Main()
//			{
//				        //Kod inicjujcy dla grupy klientw ABC
//			}
//		}
//
//		public class ClientXYZ
//		{
//			public static void Main()
//			{
//				        //Kod inicjujcy dla grupy klientw XYZ
//			}
//		}
		#endregion

        #region "3.21 Zapobieganie tworzeniu czciowo zainicjowanych obiektw"
        public static void TestLog()
		{
			Log<StreamWriter> log = new Log<StreamWriter>(new StreamWriter("c:\\foo.txt"));
			log.Write("test");
			log.LogStream.Close();
		}
		
		
		public class Log<T>
			where T: System.IO.TextWriter
		{
			public Log(T logStream)
			{
				this.logStream = logStream;
			}

			private T logStream = null;

			public T LogStream
			{
				get {return (logStream);}
				set {logStream = value;}
			}

           // Wykorzystanie pola LogStream...
            public void Write(string text)
			{
				logStream.Write(text);
			}
		}

		public class EnhancedLog<T> : Log<T>
			where T : System.IO.TextWriter
		{
			public EnhancedLog(T logStream)
				: base(logStream)
			{
                // Inicjalizacja...
			}
		}
		#endregion

        #region "3.22 Zwracanie wielu elementw przez metod"
        public void ReturnDimensions(int inputShape, 
			out int height, 
			out int width, 
			out int depth)
		{
			height = 0;
			width = 0;
			depth = 0;

            // Obliczenie wysokoci, szerokoci i gebokoci na podstawie wartoci inputShape
		}

		public Dimensions ReturnDimensions(int inputShape)
		{
			// Domylny konstruktor automatycznie  ustawia wartoci pl struktry na 0
			Dimensions objDim = new Dimensions();

            // Obliczenie wartoci objDim.Height, objDim.width oraz objDim.Depth na podstawie wartoci inputShape.

			return (objDim);
		}

		public struct Dimensions
		{
			public int Height;
			public int Width;
			public int Depth;
		}
		#endregion

        #region "3.23 Analiza parametrw wiersza polecenia"
        public static void Main2(string[] args)
		{
			// W przypadku braku argumentw wiersza polecenia, w tym miejscu naley 
			// zainicjowa aplikacj.

            ParseCmdLine parse = new ParseCmdLine();

            try
            {
                // Utworzenie tablicy zawierajcej wszystkie moliwe parametry wiersza polecenia
                // i sposoby ich przetwarzania.
                object[,] mySwitches = new object[2, 4] {
               {"file", "output", "trialmode", "debugoutput"},
               {ArgType.Simple, ArgType.Compound, ArgType.SimpleSwitch,
                ArgType.Complex}};
                // Ptla dla wszystkich parametrw wiersza polecenia.
                for (int counter = 0; counter < args.Length; counter++)
                {
                    args[counter] = args[counter].TrimStart(new char[2] { '/', '-' });

                    // Wyszukiwanie prawidowego ArgType i przetwarzanie argumentu zgodnie z
                    // okrelon wartoci ArgType.
                    for (int index = 0; index <= mySwitches.GetUpperBound(1); index++)
                    {
                        string theSwitch;
                        string theArgument;
                        string[] theArguments;

                        if (args[counter].StartsWith((string)mySwitches[0, index]))
                        {
                            // Przetwarzanie kazdego z argumentw do postaci opcja:arg1;arg2...
                            switch ((ArgType)mySwitches[1, index])
                            {
                                case ArgType.Simple:
                                    theSwitch = args[counter];
                                    break;

                                case ArgType.SimpleSwitch:
                                    theSwitch = parse.ParseSwitch(args[counter]);
                                    break;

                                case ArgType.Compound:
                                    parse.ParseSwitchColonArg(args[counter], out theSwitch,
                                                              out theArgument);
                                    break;

                                case ArgType.Complex:
                                    parse.ParseSwitchColonArgs(args[counter], out theSwitch,
                                                               out theArguments);
                                    break;

                                default:
                                    throw (new ArgumentException(
                                      "Bd argumentw wiersza polecenia: Warto typu ArgType " +
                                      mySwitches[1, index].ToString() +
                                      " nie zostaa rozpoznana."));
                            }

                            // Implementacja obsugi poszczeglnych
                            // argumentw wiersza polecenia.
                            switch ((string)mySwitches[0, index])
                            {
                                case "file":
                                    // Obsuga opcji...
                                    break;

                                case "output":
                                    // Obsuga opcji...
                                    break;

                                case "trialmode":
                                    // Obsuga opcji i jej argumentw...
                                    break;

                                case "debugoutput":
                                    // Obsuga opcji i jej argumentw...
                                    break;

                                default:
                                    throw (new ArgumentException(
                                        "Bd argumentw wiersza polecenia: Opcja " +
                                        mySwitches[0, index].ToString() +
                                        " nie zostaa rozpoznana."));
                            }
                        }
                    }
                }
            }
            catch (ArgumentException ae)
            {
                parse.DisplayErrorMsg(ae.ToString());
                return;
            }
            catch (Exception e)
            {
                // Obsuga pozostaych wyjtkw...
            }
        }



        public class ParseCmdLine
        {
            // Argumenty s rozdzielone tabulacjami bd spacjami.
            // Wszystkie cudzysowy s usuwane poza tymi, ktre poprzedzono ukonikiem '\'".
            // Apostrofy pozostaj bez zmian.

            public ParseCmdLine() { }

            public virtual string ParseSwitch(string arg)
            {
                arg = arg.TrimStart(new char[2] { '/', '-' });
                return (arg);
            }

            public virtual void ParseSwitchColonArg(string arg, out string outSwitch,
                                                    out string outArgument)
            {
                outSwitch = "";
                outArgument = "";

                try
                {
                    // Opcja lub para opcja/argument.
                    arg = arg.TrimStart(new char[2] { '/', '-' });

                    if (arg.IndexOf(':') >= 0)
                    {
                        outSwitch = arg.Substring(0, arg.IndexOf(':'));
                        outArgument = arg.Substring(arg.IndexOf(':') + 1);

                        if (outArgument.Trim().Length <= 0)
                        {
                            throw (new ArgumentException(
                                "Bd argumentw wiersza polecenia: za opcj " +
                                arg +
                                " musi wystpowa jeden lub kilka argumentw.", arg));
                        }
                    }
                    else
                    {
                        throw (new ArgumentException(
                                "Bd argumentw wiersza polecenia: argument " +
                                arg +
                                " musi mie posta pary 'opcja:argument}'.",
                                arg));
                    }
                }
                catch (ArgumentException ae)
                {
                    // Ponowne zgoszenie wyjtku w celu obsuenia go w metodzie wywoujcej.
                    throw;
                }
                catch (Exception e)
                {
                    // Zgoszenie wyjtku ArgumentException wraz z komunikatem o bedzie.
                    throw (new ArgumentException("Oglny bd parametru wiersza polecenia",
                                                 arg, e));
                }
            }
            public virtual void ParseSwitchColonArgs(string arg, out string outSwitch,
                                                     out string[] outArguments)
            {
                outSwitch = "";
                outArguments = null;

                try
                {
                    // Opcja lub para opcja/argument.
                    arg = arg.TrimStart(new char[2] { '/', '-' });

                    if (arg.IndexOf(':') >= 0)
                    {
                        outSwitch = arg.Substring(0, arg.IndexOf(':'));
                        string Arguments = arg.Substring(arg.IndexOf(':') + 1);

                        if (Arguments.Trim().Length <= 0)
                        {
                            throw (new ArgumentException(
                                    "Bd argumentw wiersza polecenia: za opcj " +
                                    arg +
                                    " musi wystpowa jeden lub kilka argumentw.", arg));
                        }

                        outArguments = Arguments.Split(new char[1] { ';' });
                    }
                    else
                    {
                        throw (new ArgumentException(
                            "Bd argumentw wiersza polecenia: argument " +
                            arg +
                            " musi mie posta pary 'opcja:argument}'.",
                            arg));
                    }
                }
                catch (Exception e)
                {
                    // Zgoszenie wyjtku ArgumentException.
                    throw;
                }
            }

            public virtual void DisplayErrorMsg()
            {
                DisplayErrorMsg("");
            }

            public virtual void DisplayErrorMsg(string msg)
            {
                Console.WriteLine
                    ("Wystpi bd przetwarzania argumentw wiersza polecenia:");
                Console.WriteLine(msg);
                Console.WriteLine();

                FileVersionInfo version =
                        Process.GetCurrentProcess().MainModule.FileVersionInfo;

                if (Process.GetCurrentProcess().ProcessName.Trim().Length > 0)
                {
                    Console.WriteLine(Process.GetCurrentProcess().ProcessName);
                }
                else
                {
                    Console.WriteLine("Nazwa produktu: " + version.ProductName);
                }

                Console.WriteLine("Wersja " + version.FileVersion);
                Console.WriteLine("Copyright " + version.LegalCopyright);
                Console.WriteLine("Znak handlowy " + version.LegalTrademarks);

                DisplayHelp();
            }

            public virtual void DisplayHelp()
            {
                Console.WriteLine("Informacje na temat sposobu uycia argumentw wiersza polecenia mona znale w plikach pomocy.");
            }
        }

        public class SpecializedParseCmdLine : ParseCmdLine
        {
            public SpecializedParseCmdLine() { }

            public override string ParseSwitch(string arg)
			{
        if (arg.IndexOf(':') >= 0)
        {
            //throw (new ArgumentException("Command-Line parameter error: switch " +
            //                    arg + " must be followed by one or more arguments.", arg));

            throw (new ArgumentException("Bd parametru wiersza polecenia. Za opcj " + arg + " nie mog wystpowa argumenty.", arg));
        }
        return (base.ParseSwitch(arg));
    }

            public new virtual void DisplayErrorMsg()
            {
                DisplayErrorMsg("");
            }

            public new virtual void DisplayErrorMsg(string msg)
            {
                Console.WriteLine(
                    "Wystpi bd przetwarzania argumentw wiersza polecenia:");
                Console.WriteLine();

                FileVersionInfo version = Process.GetCurrentProcess().MainModule.FileVersionInfo;
                if (Process.GetCurrentProcess().ProcessName.Trim().Length > 0)
                {
                    Console.WriteLine(Process.GetCurrentProcess().ProcessName);
                }
                else
                {
                    Console.WriteLine("Nazwa produktu: " + version.ProductName);
                }

                Console.WriteLine("Wersja " + version.FileVersion);
                Console.WriteLine("Copyright " + version.LegalCopyright);
                Console.WriteLine("Znak handlowy " + version.LegalTrademarks);

                DisplayHelp();
            }
                public override void DisplayHelp()
    {
        // Wywietlenie informacji o poprawnym sposobie uycia argumentw.
        base.DisplayHelp();

        Console.WriteLine("Przyklad [plik | /output:projectfile | /trialmode |/debugoutput:plik{;plik}]");
        Console.WriteLine();
        Console.WriteLine("Dostpne opcje wiersza polecenia:");
        Console.WriteLine("\tfile        : plik wejciowy.");
        Console.WriteLine("\toutput      : plik wynikowy.");
        Console.WriteLine("\ttrialmode   : wczenie trybu wersji prbnej.");
        Console.WriteLine("\tdebugoutput : jeden lub kilka plikw, w ktrych maj si znale informacje dotyczce debugowania.");
    }
}

        enum ArgType
        {
            Simple = 0,        //Prosta nazwa pliku bez poprzedzajcych j znakw  '/' bd '-'
            SimpleSwitch = 1,  //Opcja poprzedzona znakiem '/' bd '-'
            Compound = 2,      //Para opcja: argument' poprzedzona znakami  '/' lub '-'
            Complex = 3        //Para 'opcja:argument{;argument}' zawierajca wiele argumentw
                               // poprzedzona znakiem '/' lub '-'.
        }
        #endregion

        #region "3.24 Przystosowanie klasy do wsppracy z obiektami COM"
        //[assembly: GuidAttribute("D4E77B72-43C8-45f1-B0C0-D47685EC18C2")]
		
		[GuidAttribute("1C6CD700-A37B-4295-9CC9-D7392FDD425D")]
		public interface IFoo
		{
			string PrintMe();
			int ShowState();
			void SetState(int newState);
		}

		[GuidAttribute("C09E2DD6-03EE-4fef-BB84-05D3422DD3D9")]
		[ClassInterfaceAttribute(ClassInterfaceType.AutoDispatch)]
		[ProgIdAttribute("Chapter_Code.Foo")]
		public class FooOther : IFoo
		{
			public FooOther() {}

			private int state = 100;

			public string PrintMe()
			{
                return ("TEST ZAKOCZONY SUKCESEM");
			}

			public int ShowState()
			{
				return (state);
			}

			public void SetState(int newState)
			{
				state = newState;
			}
		}
		#endregion

        #region "Inicjowanie staej w fazie wykonywania programu"
        public class Foo2
		{
			public readonly int Bar;

			public Foo2() {}

			public Foo2(int constInitValue)
			{
				Bar = constInitValue;
			}

            // Pozostaa cz klasy...
		}

		public class Foo22
		{
			public const int Bar = 100;

			public Foo22() {}

			public Foo22(int constInitValue)
			{
                //Bar = constInitValue;    // Ten wiersz take spowoduje bad kompilacji
			}

            // Pozostaa cz klasy...
		}
		#endregion

        #region "3.26 Pisanie kodu zgodnego z jak najwiksz liczb zarzdzanych jzykw"
        // USE:   [assembly: CLSCompliantAttribute(true)]
        #endregion

        #region "3.27 Tworzenie klas, ktre mona klonowa"
        public static void TestCloning()
		{
			ShallowClone sc = new ShallowClone();
			sc.ListData.Add("asdf");
			ShallowClone scCloned = (ShallowClone)sc.Clone();
			Console.WriteLine("scCloned.ListData.Remove(\"asdf\") == " + scCloned.ListData.Remove("asdf"));

			DeepClone dc = new DeepClone();
			dc.ListData.Add("asdf");
			DeepClone dcCloned = (DeepClone)dc.Clone();
			dcCloned.ListData.Remove("asdf");
			Console.WriteLine("dc.ListData.Contains(\"asdf\") == " + dc.ListData.Contains("asdf"));
			Console.WriteLine("dcCloned.ListData.Contains(\"asdf\") == " + dcCloned.ListData.Contains("asdf"));

			MultiClone mc = new MultiClone();
			mc.ListData.Add("asdf");
			MultiClone mcCloned = (MultiClone)mc.Clone(true);
			Console.WriteLine("mcCloned.ListData.Contains(\"asdf\") == " + mcCloned.ListData.Contains("asdf"));
			Console.WriteLine("mc.ListData.Contains(\"asdf\") == " + mc.ListData.Contains("asdf"));
		}
		
		
		public class ShallowClone : ICloneable
		{
			public int Data = 1;
			public List<string> ListData = new List<string>();
			public object ObjData = new object();

			public object Clone()
			{
				return (this.MemberwiseClone());
			}
		}

		[Serializable]
		public class DeepClone : ICloneable
		{
			public int data = 1;
			public List<string> ListData = new List<string>();
			public object objData = new object();

			public object Clone()
			{
				BinaryFormatter BF = new BinaryFormatter();
				MemoryStream memStream = new MemoryStream();

				BF.Serialize(memStream, this);
				memStream.Flush();
				memStream.Position = 0;

				return (BF.Deserialize(memStream));
			}
		}

		[Serializable]
		public class MultiClone : ICloneable
		{
			public int data = 1;
			public List<string> ListData = new List<string>();
			public object objData = new object();

			public object Clone(bool doDeepCopy)
			{
				if (doDeepCopy)
				{
					BinaryFormatter BF = new BinaryFormatter();
					MemoryStream memStream = new MemoryStream();

					BF.Serialize(memStream, this);
					memStream.Flush();
					memStream.Position = 0;

					return (BF.Deserialize(memStream));
				}
				else
				{
					return (this.MemberwiseClone());
				}
			}

			public object Clone()
			{
				return (Clone(false));
			}
		}
		#endregion

        #region "3.28 Zapewnienie niszczenia obiektu"
        public static void DisposeObj1()
		{
			using(FileStream FS = new FileStream("Test.txt", FileMode.Create))
			{
				FS.WriteByte((byte)1);
				FS.WriteByte((byte)2);
				FS.WriteByte((byte)3);

				using(StreamWriter SW = new StreamWriter(FS))
				{
                    SW.WriteLine("jaki tekst");
				}
			}
		}
		
		public static void DisposeObj2()
		{
			FileStream FS = new FileStream("Test.txt", FileMode.Create);
			try
			{
				FS.WriteByte((byte)1);
				FS.WriteByte((byte)2);
				FS.WriteByte((byte)3);

				StreamWriter SW = new StreamWriter(FS);
				try
				{
                    SW.WriteLine("jaki tekst");
				}
				finally
				{
					if (SW != null)
					{
						((IDisposable)SW).Dispose();
					}
				}
			}
			finally
			{
				if (FS != null)
				{
					((IDisposable)FS).Dispose();
				}
			}
		}
        #endregion

        #region "3.29 Zwalnianie obiektu COM z poziomu zarzdzanego kodu"
        //USE:
        // int newRefCount = System.Runtime.InteropServices.Marshal.ReleaseComObject(someCOMObj);
        #endregion

        #region "3.30 Tworzenie pamici podrcznej obiektw"
        // Utworzenie pamici podrcznej.
        static ObjCache<string, SomeComplexObj> OC = new ObjCache<string, SomeComplexObj>();

        public static void TestObjCache()
        {
            OC.AddObj("ID1", new SomeComplexObj());
            OC.AddObj("ID2", new SomeComplexObj());
            OC.AddObj("ID3", new SomeComplexObj());
            OC.AddObj("ID4", new SomeComplexObj());
            OC.AddObj("ID5", new SomeComplexObj());

            Console.WriteLine("\r\n--> Dodanie 5 sabych referencji");
            Console.WriteLine("OC.TotalCacheSlots = " + OC.TotalCacheSlots());
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());
            Console.WriteLine("OC.ExistsInGeneration('ID1') = " + OC.ExistsInGeneration("ID1"));

            //////////////// POCZTEK ODMIECANIA ////////////////
            GC.Collect();
            GC.WaitForPendingFinalizers();
            //////////////// KONIEC ODMIECANIA //////////////////

            Console.WriteLine("\r\n--> Likwidacja wszystkich sabych referencji");
            Console.WriteLine("OC.TotalCacheSlots = " + OC.TotalCacheSlots());
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());

            OC.AddObj("ID1", new SomeComplexObj());
            OC.AddObj("ID2", new SomeComplexObj());
            OC.AddObj("ID3", new SomeComplexObj());
            OC.AddObj("ID4", new SomeComplexObj());
            OC.AddObj("ID5", new SomeComplexObj());

            Console.WriteLine("\r\n--> Dodanie 5 sabych referencji");
            Console.WriteLine("OC.TotalCacheSlots = " + OC.TotalCacheSlots());
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());

            CreateObjLongMethod();
            Create135();
            CollectAll();
        }

        private static void CreateObjLongMethod()
        {
            Console.WriteLine("\r\n--> Pobieranie ID1");
            if (OC.IsObjAlive("ID1"))
            {
                SomeComplexObj SCOTemp = OC.GetObj("ID1");
                SCOTemp.IDCode = 100;
                Console.WriteLine("SCOTemp.IDCode = " + SCOTemp.IDCode);
            }
            else
            {
                Console.WriteLine("Obiekt ID1 nie istnieje...Utworzenie nowego obiektu ID1...");
                OC.AddObj("ID1", new SomeComplexObj());
                SomeComplexObj SCOTemp = OC.GetObj("ID1");
                SCOTemp.IDCode = 101;
                Console.WriteLine("SCOTemp.IDCode = " + SCOTemp.IDCode);
            }
        }

        private static void Create135()
        {
            Console.WriteLine("OC.ExistsInGeneration('ID1') = " + OC.ExistsInGeneration("ID1"));
            Console.WriteLine("\r\n--> Pobieranie ID1, ID3, ID5");
            SomeComplexObj SCO1 = OC.GetObj("ID1");
            SomeComplexObj SCO3 = OC.GetObj("ID3");
            SomeComplexObj SCO5 = OC.GetObj("ID5");
            SCO1.IDCode = 1000;
            SCO3.IDCode = 3000;
            SCO5.IDCode = 5000;
            Console.WriteLine("OC.ExistsInGeneration('ID1') = " + OC.ExistsInGeneration("ID1"));

            //////////////// POCZTEK ODMIECANIA ///////////////
            GC.Collect();
            GC.WaitForPendingFinalizers();
            //////////////// KONIEC ODMIECANIA //////////////////


            Console.WriteLine("\r\n--> Likwidacja wszystkich sabych referencji");
            Console.WriteLine("OC.TotalCacheSlots = " + OC.TotalCacheSlots());
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());
            Console.WriteLine("OC.ExistsInGeneration('ID1') = " + OC.ExistsInGeneration("ID1"));

            Console.WriteLine("SCO1.IDCode = " + SCO1.IDCode);
            Console.WriteLine("SCO3.IDCode = " + SCO3.IDCode);
            Console.WriteLine("SCO5.IDCode = " + SCO5.IDCode);

            Console.WriteLine("\r\n--> Prba pobrania ID2, ktry zlikwidowano.  ID2 istnieje " +
                OC.IsObjAlive("ID2"));
            SomeComplexObj SCO2 = OC.GetObj("ID2");
            Console.WriteLine("\r\n--> Odtworzono ID2.  ID2 istnieje " + OC.IsObjAlive("ID2"));
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());
            SCO2.IDCode = 2000;
            Console.WriteLine("SCO2.IDCode = " + SCO2.IDCode);


            //////////////// POCZTEK ODMIECANIA ////////////////
            GC.Collect();
            GC.WaitForPendingFinalizers();
            //////////////// KONIEC ODMIECANIA ////////////////

            Console.WriteLine("\r\n--> Likwidacja wszystkich sabych referencji");
            Console.WriteLine("OC.TotalCacheSlots = " + OC.TotalCacheSlots());
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());
            Console.WriteLine("OC.ExistsInGeneration('ID1') = " + OC.ExistsInGeneration("ID1"));
            Console.WriteLine("OC.ExistsInGeneration('ID2') = " + OC.ExistsInGeneration("ID2"));
            Console.WriteLine("OC.ExistsInGeneration('ID3') = " + OC.ExistsInGeneration("ID3"));
        }

        private static void CollectAll()
        {
            //////////////// POCZTEK ODMIECANIA //////////////////
            GC.Collect();
            GC.WaitForPendingFinalizers();
            //////////////// KONIEC ODMIECANIA //////////////////


            Console.WriteLine("\r\n--> Likwidacja wszystkich sabych referencji");
            Console.WriteLine("OC.TotalCacheSlots = " + OC.TotalCacheSlots());
            Console.WriteLine("OC.AliveObjsInCache = " + OC.AliveObjsInCache());
            Console.WriteLine("OC.ExistsInGeneration('ID1') = " + OC.ExistsInGeneration("ID1"));
            Console.WriteLine("OC.ExistsInGeneration('ID2') = " + OC.ExistsInGeneration("ID2"));
            Console.WriteLine("OC.ExistsInGeneration('ID3') = " + OC.ExistsInGeneration("ID3"));
            Console.WriteLine("OC.ExistsInGeneration('ID5') = " + OC.ExistsInGeneration("ID5"));
        }




		public class ObjCache<T, U>
			where U: new()
		{
			// Konstruktory
			public ObjCache()
			{
				cache = new Dictionary<T, WeakReference>();
			}

			public ObjCache(int initialCapacity)
			{
				cache = new Dictionary<T, WeakReference>(initialCapacity);
			}

			// Pola
			private Dictionary<T, WeakReference> cache = null;
			private float numberOfGets = 0;
			private float numberOfHits = 0;

			// Metody
			public float HitMissRatioPcnt()
			{
				if (numberOfGets == 0)
				{
					return (0);
				}
				else
				{
					return ((numberOfHits / numberOfGets) * 100);
				}
			}

			public U GetObj(T key)
			{
				++numberOfGets;

				if (!cache.ContainsKey(key) || !IsObjAlive(key))
				{
					AddObj(key, new U());
				}
				else
				{
					++numberOfHits;
				}

				return ((U)((WeakReference)cache[key]).Target);
			}

			public U GetObj(T key, U obj)
			{
				++numberOfGets;

				if (!cache.ContainsKey(key) || !IsObjAlive(key))
				{
					return (default(U));
				}
				else
				{
					++numberOfHits;
					return ((U)((WeakReference)cache[key]).Target);
				}
			}

			public void AddObj(T key, U item)
			{
				WeakReference WR = new WeakReference(item, false);

				if (cache.ContainsKey(key))
				{
					cache[key] = WR;
				}
				else
				{
					cache.Add(key, WR);
				}
			}

			public bool IsObjAlive(T key)
			{
				if (cache.ContainsKey(key))						
				{
					return (((WeakReference)cache[key]).IsAlive);
				}
				else
				{
					return (false);
				}
			}

			public int AliveObjsInCache()
			{
				int count = 0;

				foreach (KeyValuePair<T, WeakReference> item in cache)
				{
					if (((WeakReference)item.Value).IsAlive)
					{
						count++;
					}
				}

				return (count);
			}

			public int ExistsInGeneration(T key)
			{
				int retVal = -1;

				if (cache.ContainsKey(key) && IsObjAlive(key))
				{
					retVal = GC.GetGeneration((WeakReference)cache[key]);
				}

				return (retVal);
			}

			public bool DoesKeyExist(T key)
			{
				return (cache.ContainsKey(key));
			}

			public bool DoesObjExist(WeakReference obj)
			{
				return (cache.ContainsValue(obj));
			}

			public int TotalCacheSlots()
			{
				return (cache.Count);
			}
		}

		public class SomeComplexObj
		{
			public SomeComplexObj()
			{
			}

			private int idcode = -1;

			public int IDCode
			{
				set
				{
					idcode = value;
				}
				get
				{
					return (idcode);
				}
			}
		}
        #endregion

        #region "3.31 Klasa z jednym egzemplarzem"
        public static void TestStaticClasses()
        {
			OnlyOne<int> oo = OnlyOne<int>.GetInstance();
			oo.Method1();
			
			OnlyStaticOne<int>.Method1();

			OnlyThree<int> ot1 = OnlyThree<int>.GetInstance();
			Console.WriteLine("ot1.GetHashCode() == " + ot1.GetHashCode());

			OnlyThree<int> ot2 = OnlyThree<int>.GetInstance();
			Console.WriteLine("ot2.GetHashCode() == " + ot2.GetHashCode());

			OnlyThree<int> ot3 = OnlyThree<int>.GetInstance();
			Console.WriteLine("ot3.GetHashCode() == " + ot3.GetHashCode());

			OnlyThree<int> ot4 = OnlyThree<int>.GetInstance();
			Console.WriteLine("ot4.GetHashCode() == " + ot4.GetHashCode());
		}
        
        
		public sealed class OnlyOne<T>
		{
			private OnlyOne() {}

			private static OnlyOne<T> theOneObject = null;

			public static OnlyOne<T> GetInstance()
			{
				lock (typeof(OnlyOne<T>))
				{
					if (theOneObject == null)
					{
						OnlyOne<T>.theOneObject = new OnlyOne<T>();
					}
				
					return (OnlyOne<T>.theOneObject);
				}
			}

			public void Method1() {}
			public void Method2() {} 
		}

		public static class OnlyStaticOne<T>
		{
			static OnlyStaticOne() {}
			
			public static void Method1() {}
			public static void Method2() {}
		}

		public sealed class OnlyThree<T>
		{
			private OnlyThree() 
			{
				count++;
			}

			private static OnlyThree<T>[] anObject = new OnlyThree<T>[3];
			private static int count = 0;
			private static int lastObjReturned = 0;
			private const int maxInstances = 3;

			public static OnlyThree<T> GetInstance()
			{
				if (count < maxInstances)
				{
					OnlyThree<T>.anObject[count] = new OnlyThree<T>();
					lastObjReturned = count;
				}
				else
				{
					if (lastObjReturned == 1)
					{
						lastObjReturned = maxInstances;
					}
					else
					{
						lastObjReturned--;
					}
				}

				return (OnlyThree<T>.anObject[lastObjReturned - 1]);
			}

			public void Method1() {}
			public void Method2() {}
		}
		#endregion

        #region "3.32 Wybr serializatora"
        public static void TestSerializationFacade()
        {
            Serializer<int[]> s = new Serializer<int[]>();
            s.SerializeObj(new int[10] {1,2,3,4,5,6,7,8,9,10}, @"TestBinSerXML.txt", 
                SerializationAction.AsXML);
            int[] retArray = s.DeSerializeObj(@"TestBinSerXML.txt");
            
            foreach (int i in retArray)
				Console.WriteLine(i);
        }
 
		[Serializable]
		public class Serializer<T>
		{
			public Serializer() {}


			protected Dictionary<string, DeserializationType> serializationMap = new Dictionary<string, DeserializationType>();
			protected Dictionary<string, string> serializationTypeOfMap = new Dictionary<string, string>();


			// Serialize an object
			public void SerializeObj(T obj, string destination)
			{
				SerializeObj(obj, destination, SerializationAction.Default);
			}

			public void SerializeObj(T obj, string destination, SerializationAction action)
			{
				if (action == SerializationAction.RetainAssemblyInfo   ||
					action == SerializationAction.RetainPrivateMembers ||
					action == SerializationAction.SmallestFootprint    ||
					action == SerializationAction.Default)
				{
					BinarySerializeObj(obj, destination);
					serializationMap.Add(destination.ToUpper(), DeserializationType.Binary);
				}
				else if (action == SerializationAction.MakePortable ||
					action == SerializationAction.AsSOAPMsg)
				{
					SoapSerializeObj(obj, destination);
					serializationMap.Add(destination.ToUpper(), DeserializationType.SOAP);
				}
				else  if (action == SerializationAction.AsXML ||
					action == SerializationAction.SendToXMLWebService)
				{
					XmlSerializeObj(obj, destination);
					serializationMap.Add(destination.ToUpper(), DeserializationType.XML);
					serializationTypeOfMap.Add(destination.ToUpper(), obj.GetType().FullName);
				}
			}

			private void BinarySerializeObj(T obj, string destination)
			{
				BinaryFormatter binFormatter = new BinaryFormatter();
				Stream fileStream = new FileStream(destination, FileMode.Create, FileAccess.Write, 
					FileShare.None);
				binFormatter.Serialize(fileStream, obj);
				fileStream.Close();
			}

			private void SoapSerializeObj(T obj, string destination)
			{
				SoapFormatter SOAPFormatter = new SoapFormatter();
				Stream fileStream = new FileStream(destination, FileMode.Create, FileAccess.Write, 
					FileShare.None);
				SOAPFormatter.Serialize(fileStream, obj);
				fileStream.Close();
			}

			private void XmlSerializeObj(T obj, string destination)
			{
				XmlSerializer XMLFormatter = new XmlSerializer(obj.GetType());
				Stream fileStream = new FileStream(destination, FileMode.Create, FileAccess.Write, 
					FileShare.None);
				XMLFormatter.Serialize(fileStream, obj);
				fileStream.Close();
			}


			// DeSerialize an object
			public T DeSerializeObj(string source)
			{
				return (DeSerializeObj(source, 
					(DeserializationType)serializationMap[source.ToUpper()]));
			}

			public T DeSerializeObj(string source, DeserializationType type)
			{
				object retObj = null;

				if (type == DeserializationType.Binary)
				{
					retObj = BinaryDeSerializeObj(source);
					serializationMap.Remove(source.ToUpper());
				}
				else if (type == DeserializationType.SOAP)
				{
					retObj = SoapDeSerializeObj(source);
					serializationMap.Remove(source.ToUpper());
				}
				else if (type == DeserializationType.XML)
				{
					retObj = XmlDeSerializeObj(source);
					serializationMap.Remove(source.ToUpper());
					serializationTypeOfMap.Remove(source.ToUpper());
				}

				return ((T)retObj);
			}

			private T BinaryDeSerializeObj(string source)
			{
				BinaryFormatter binFormatter = new BinaryFormatter();
				Stream fileStream = new FileStream(source, FileMode.Open, FileAccess.Read, 
					FileShare.None);
				object DeserializedObj = binFormatter.Deserialize(fileStream);
				fileStream.Close();

				return ((T)DeserializedObj);
			}    

			private T SoapDeSerializeObj(string source)
			{
				SoapFormatter SOAPFormatter = new SoapFormatter();
				Stream fileStream = new FileStream(source, FileMode.Open, FileAccess.Read, 
					FileShare.None);
				object DeserializedObj = SOAPFormatter.Deserialize(fileStream);
				fileStream.Close();

				return ((T)DeserializedObj);
			}

			private T XmlDeSerializeObj(string source)
			{
				XmlSerializer XMLFormatter = new 
					XmlSerializer(Type.GetType((string)serializationTypeOfMap[source.ToUpper()]));
				Stream fileStream = new FileStream(source, FileMode.Open, FileAccess.Read, 
					FileShare.None);
				object DeserializedObj = XMLFormatter.Deserialize(fileStream);
				fileStream.Close();

				return ((T)DeserializedObj);
			}
		}


		public enum SerializationAction
		{
			Default = 0,
			RetainAssemblyInfo,
			RetainPrivateMembers,
			MakePortable,
			SmallestFootprint,
			SendToXMLWebService,
			AsSOAPMsg,
			AsXML
		}

		public enum DeserializationType
		{
			Binary = 0,
			SOAP,
			XML
		}
		#endregion

        #region "3.33 Cofanie modyfikacji w obiektach"
        public static void TestMemento1()
        {
        // Utworzenie obiektu originator i nadanie mu wartoci domylnej stanu wewntrznego.
SomeDataOriginator data = new SomeDataOriginator();
Console.WriteLine("ORYGINA");
data.Display();

// Utworzenie obiektu caretaker.
MementoCareTaker<SomeDataOriginator.Memento>objState = 
    new MementoCareTaker<SomeDataOriginator.Memento>();
// Dodanie obiektu  memento pierwotnego obiektu originator do obiektu caretaker.
objState.Memento = new SomeDataOriginator.Memento(data);

// Zmiana wewntrznego stanu obiektu originator.
data.ChangeState(67);
data.ID = "foo";
data.ClassName = "bar";
Console.WriteLine("NOWY");
data.Display();

// Cofnicie zmian obiektu originator do stanu pocztkowego
objState.Memento.Rollback();
Console.WriteLine("PO COFNICIU ZMIAN");
data.Display();

        }
			
        public static void TestMemento2()
        {
        SomeDataOriginator Data = new SomeDataOriginator();
Console.WriteLine("ORYGINA");
Data.Display();

MultiMementoCareTaker<SomeDataOriginator.Memento>MultiObjState = new
MultiMementoCareTaker<SomeDataOriginator.Memento>();
MultiObjState.Add(new SomeDataOriginator.Memento(Data));

Data.ChangeState(67);
Data.ID = "foo";
Data.ClassName = "bar";
Console.WriteLine("NOWY");
Data.Display();
MultiObjState.Add(new SomeDataOriginator.Memento(Data));

Data.ChangeState(671);
Data.ID = "foo1";
Data.ClassName = "bar1";
Console.WriteLine("NOWY1");
Data.Display();
MultiObjState.Add(new SomeDataOriginator.Memento(Data));

Data.ChangeState(672);
Data.ID = "foo2";
Data.ClassName = "bar2";
Console.WriteLine("NOWY2");
Data.Display();
MultiObjState.Add(new SomeDataOriginator.Memento(Data));

Data.ChangeState(673);
Data.ID = "foo3";
Data.ClassName = "bar3";
Console.WriteLine("NOWY3");
Data.Display();

for (int Index = (MultiObjState.Count - 1); Index >= 0; Index--)
{
Console.WriteLine("\r\nCOFNICIE ZMIAN(" + Index + ")");
MultiObjState[Index].Rollback();
Data.Display();
}

        }

        public class SomeDataOriginator
        {
            public SomeDataOriginator() { }

            public SomeDataOriginator(int state, string id, string clsName)
            {
                this.state = state;
                this.id = id;
                this.clsName = clsName;
            }

            private int state = 1;
            private string id = "ID1001";
            private string clsName = "SomeDataOriginator";

            public string ClassName
            {
                get { return (clsName); }
                set { clsName = value; }
            }

            public string ID
            {
                get { return (id); }
                set { id = value; }
            }

            public void ChangeState(int newState)
            {
                state = newState;
            }

            public void Display()
            {
                Console.WriteLine("Stan: " + state);
                Console.WriteLine("Id: " + id);
                Console.WriteLine("clsName: " + clsName);
            }

            // Zagniedona klasa Memento wykorzystywana do zapisania stanu klasy zewntrznej.
            public class Memento
            {
                public Memento(SomeDataOriginator data)
                {
                    this.state = data.state;
                    this.id = data.id;
                    this.clsName = data.clsName;
                    this.originator = data;
                }

                private SomeDataOriginator originator = null;
                private int state = 1;
                private string id = "ID1001";
                private string clsName = "SomeDataOriginator";

                internal void Rollback()
                {
                    originator.clsName = this.clsName;
                    originator.id = this.id;
                    originator.state = this.state;
                }
            }
        }

        public class MementoCareTaker<T>
            where T : SomeDataOriginator.Memento
        {
            private T savedState = default(T);

            public T Memento
            {
                get { return (savedState); }
                set { savedState = value; }
            }
        }

        public class MultiMementoCareTaker<T>
    where T : SomeDataOriginator.Memento
        {
            private List<T> savedState = new List<T>();

            public T this[int index]
            {
                get { return (savedState[index]); }
                set { savedState[index] = value; }
            }

            public void Add(T memento)
            {
                savedState.Add(memento);
            }

            public int Count
            {
                get { return (savedState.Count); }
            }
        }


		public interface IMemento
		{
			void Rollback();
		}
		#endregion

        #region "3.34 Zwalnianie niezarzdzanych zasobw"
        [DllImport("Kernel32.dll", SetLastError = true)]
		private static extern IntPtr CreateSemaphore(IntPtr lpSemaphoreAttributes, int lInitialCount, int lMaximumCount, string lpName);

		[DllImport("Kernel32.dll", SetLastError = true)]
		private static extern bool ReleaseSemaphore(IntPtr hSemaphore, int lReleaseCount, out IntPtr lpPreviousCount);


		public class FooD : IDisposable
		{
			public FooD() {}


            // Obiekt  SomeCOMObj naley zastpi wasnym obiektem COM
			private SomeCOMObj comObj = new SomeCOMObj();
			private FileStream fileStream = new FileStream(@"c:\test.txt", FileMode.OpenOrCreate);
			private ArrayList aList = new ArrayList();
			private bool hasBeenDisposed = false;
			private IntPtr hSemaphore = IntPtr.Zero;
			// Kontener na obiekty
			private System.ComponentModel.Container containedObjs = new System.ComponentModel.Container();
			// Gdzie wewntrz klasy naley wypeni kontener obiektami

			public class SomeCOMObj {}

            // Zabezpieczenie przed wykorzystywaniem skadowych w zwolnionym obiekcie.
			public void WriteToFile(string text)
			{
				if(hasBeenDisposed)
				{
					throw (new ObjectDisposedException(this.ToString(),
                        "Obiekt zosta zwolniony"));
				}

				System.Text.UnicodeEncoding enc = new System.Text.UnicodeEncoding();
				fileStream.Write(enc.GetBytes(text), 0, text.Length);
			}

			public void UseCOMObj()
			{
				if(hasBeenDisposed)
				{
					throw (new ObjectDisposedException(this.ToString(),
                        "Obiekt zosta zwolniony"));
				}

				Console.WriteLine("GUID: " + comObj.GetType().GUID);
			}

			public void AddToList(object obj)
			{
				if(hasBeenDisposed)
				{
					throw (new ObjectDisposedException(this.ToString(),
                        "Obiekt zosta zwolniony"));
				}

				aList.Add(obj);
			}

			public void CreateSemephore()
			{
                // Utworzenie uchwytu do niezarzdzanego kodu.
				hSemaphore = CreateSemaphore(IntPtr.Zero, 5, 5, null);
			}


            // Metody Dispose
			public void Dispose()
			{
				Dispose(true);
			}

			protected virtual void Dispose(bool disposeManagedObjs)
			{
				if (!hasBeenDisposed)
				{
					if (disposeManagedObjs)
					{
						// Zwolnienie zarzdzanych obiektw, ktre nie implementuj interfejsu IDisposable

                        //  Zwolnienie wszystkich elementw w tablicy bd obiekcie ArrayList.
						foreach (object obj in aList)
						{
							IDisposable disposableObj = obj as IDisposable;
							if (disposableObj != null)
							{
								disposableObj.Dispose();
							}
						}

                        // Zwolnienie zarzdzanych obiektw implementujcych interfejs IDisposable.
						fileStream.Close();
		
						// Zwolnienie obiektw w kontenerze, ktre implementuj interfejs IDisposable
						containedObjs.Dispose();

                        //  Zmniejszenie licznika referencji w metodzie RCW.
						while (Marshal.ReleaseComObject(comObj) > 0);

						GC.SuppressFinalize(this);
					}

                    // Zwolnienie uchwytu do niezarzdzanego kodu.
					IntPtr prevCnt = new IntPtr();
					ReleaseSemaphore(hSemaphore, 1, out prevCnt);

					hasBeenDisposed = true;
				}
			}

            // Destruktor
			~FooD()
			{
				Dispose(false);
			}

            // Opcjonalna metoda Close
			public void Close()
			{
				Dispose();
			}
		}

        // Klasa dziedziczy wasnoci od klasyIDisposable.
		public class Bar : FooD
		{
			//...

			private bool hasBeenDisposed = false;


			protected override void Dispose(bool disposeManagedObjs)
			{
				if (!hasBeenDisposed)
				{
					try
					{
						if(disposeManagedObjs)
						{
                            // Wywoanie metod Dispose/Close/Cleardla zarzdzanych obiektw...
						}

                        //  Zwolnienie zarzdzanych obiektw...
					}
					finally
					{
                        // Wywoanie metody Dispose klasy bazowej.
						base.Dispose(disposeManagedObjs);
						hasBeenDisposed = true;
					}
				}
			}
		}
		#endregion

        #region "3.35 Wyszukiwanie operacji pakowania i rozpakowania"
        // Opis znajduje si w recepturze 3.32 w tekcie ksiki.
		#endregion
	}
}
